unit LinkDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, jpeg, ExtCtrls;

type
  TLinkForm = class(TForm)
    lbLinks: TListBox;
    btnJump: TBitBtn;
    btnCancel: TBitBtn;
    Status: TStatusBar;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Image1: TImage;
    lblGregLiefURL: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure lbLinksDblClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure lbLinksKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure lbLinksClick(Sender: TObject);
    procedure lbLinksDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure lbLinksMeasureItem(Control: TWinControl; Index: Integer;
      var Height: Integer);
    procedure Image1DblClick(Sender: TObject);
    procedure lblGregLiefURLDblClick(Sender: TObject);
  private
    URLs : TStringList ;
    procedure SaveLinkFile ;
  end;

procedure DisplayLinkDialog ;

implementation

uses ShellAPI ;

const
   LinksFile : string = 'GLDelphiLinks.dat' ;
   SEPARATOR = '|' ;
   GREG_LIEF_LINK = 'Greg Lief''s Delphi Resources' + SEPARATOR + 'http://www.greglief.com/delphi.shtml' ;

{$R *.DFM}

procedure DisplayLinkDialog ;
var
  f : TLinkForm;
  OldHintPause : integer ;
begin
     f := TLinkForm.Create(nil) ;
     OldHintPause := Application.HintHidePause ;
     with f do
        try
           Application.HintHidePause := 5000 ;
           if ShowModal = mrOK then
              ShellExecute(0, 'open', PChar(URLs[lbLinks.ItemIndex]), nil, nil, SW_SHOWNORMAL) ;
        finally
           Free ;
           Application.HintHidePause := OldHintPause ;
        end ;
end ;

procedure TLinkForm.FormCreate(Sender: TObject);
var
   tempPos : integer ;
   x : integer ;
   temp : TStringList ;
begin
     URLs := TStringList.Create ;
     temp := TStringList.Create ;
     try
        // if links file does not already exist, create it now
        if not FileExists(LinksFile) then begin
           temp.Add( GREG_LIEF_LINK ) ;
           temp.Add('Borland: Delphi downloads' + SEPARATOR + 'http://www.borland.com/devsupport/delphi/downloads/index.html') ;
           temp.Add('Borland: Delphi FAQ' + SEPARATOR + 'http://www.borland.com/devsupport/delphi/faq/') ;
{$IFDEF VER100}
           temp.Add('Borland: Delphi 3 fixes/patches' + SEPARATOR + 'http://www.borland.com/devsupport/delphi/fixes/3update/index.html') ;
{$ENDIF}
{$IFDEF VER120}
           temp.Add('Borland: Delphi 4 fixes/patches' + SEPARATOR + 'http://www.borland.com/devsupport/delphi/fixes/delphi4/index.html') ;
{$ENDIF}
{$IFDEF VER130}
           temp.Add('Borland: Delphi 5 fixes/patches' + SEPARATOR + 'http://www.borland.com/devsupport/delphi/fixes/delphi5/index.html') ;
{$ENDIF}
           temp.Add('developers.href.com Newsgroup Search' + SEPARATOR + 'http://developers.href.com/') ;
           temp.Add('Delphi Jobs' + SEPARATOR + 'http://www.delphiworld.com/jobs/') ;
           temp.Add('Delphi Super Page (US mirror)' + SEPARATOR + 'http://community.borland.com/homepages/dsp/index.htm') ;
           temp.Add('Mission Delphi' + SEPARATOR + 'http://www.missiondelphi.com') ;
           temp.Add('Torry''s Delphi Pages' + SEPARATOR + 'http://www.torry.ru/') ;
           temp.SaveToFile(LinksFile) ;
        end ;
        // load in URLs from links file
        lbLinks.Items.Clear ;
        temp.Clear ;
        temp.LoadFromFile(LinksFile) ;
        if temp.Count > 0 then begin
           // make sure that my link is still at the top of the file... if not, add it!
           if temp[0] <> GREG_LIEF_LINK then begin
              temp.Insert(0, GREG_LIEF_LINK) ;
              temp.SaveToFile(LinksFile) ;
           end ;
           // loop through and add items to listbox
           for x := 0 to temp.Count - 1 do begin
              tempPos := Pos(SEPARATOR, temp[x]) ;
              lbLinks.Items.Add( Copy(temp[x], 1, tempPos - 1) ) ;
              URLs.Add( Copy(temp[x], tempPos + 1, Length(temp[x]))) ;
           end ;
        end ;   
     finally
        temp.Free ;
     end ;
     lbLinks.ItemIndex := 0 ;
     Image1.Hint := 'Thanks for using my Delphi Links Expert!' + #13 +
                    'If you like this, please try my G.L.A.D. component package,' + #13 +
                    'which can be found at http://www.greglief.com/glad' ;
end;

procedure TLinkForm.lbLinksDblClick(Sender: TObject);
begin
     ModalResult := mrOK ;
end;

procedure TLinkForm.FormDestroy(Sender: TObject);
begin
     URLs.Free ;
end;

procedure TLinkForm.lbLinksKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
   sDescription : string ;
   sURL : string ;
begin
     case Key of
        VK_INSERT : begin
                       sURL := 'http://' ;
                       if InputQuery('New Delphi Link', 'Enter URL', sURL) and
                          InputQuery(sURL, 'Enter description', sDescription) then begin
                          URLs.Insert(lbLinks.ItemIndex + 1, sURL) ;
                          lbLinks.Items.Insert(lbLinks.ItemIndex + 1, sDescription) ;
                          SaveLinkFile ;
                       end ;
                    end ;

                    // NOTE: ItemIndex zero is my link, which cannot be deleted!
        VK_DELETE : if (lbLinks.ItemIndex > 0) and (MessageDlg('Delete "' + lbLinks.Items[lbLinks.ItemIndex] + '"?',
                                                   mtConfirmation, [mbOK,mbCancel], 0) = mrOK) then begin
                       URLs.Delete(lbLinks.ItemIndex) ;
                       lbLinks.Items.Delete(lbLinks.ItemIndex) ;
                       SaveLinkFile ;
                    end ;
     end ;
end;

procedure TLinkForm.lbLinksClick(Sender: TObject);
begin
     Status.SimpleText := URLs[lbLinks.ItemIndex] ;
     btnJump.Hint := 'Click to visit ' + lbLinks.Items[lbLinks.ItemIndex] ; 
end;

procedure TLinkForm.SaveLinkFile ;
var
   temp : TStringList ;
   x : integer ;
begin
     temp := TStringList.Create ;
     try
        for x := 0 to URLs.Count - 1 do
           temp.Add(lbLinks.Items[x] + SEPARATOR + URLs[x]) ;
        temp.SaveToFile(LinksFile) ;
     finally
        temp.Free ;
     end ;
end ;

procedure TLinkForm.lbLinksDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
begin
     with Control as TListBox do begin
        if Index = 0 then
           if odSelected in State then
              Canvas.Font.Style := [fsBold,fsItalic]
           else
              Canvas.Font.Style := [fsBold] ;
        Canvas.FillRect(Rect) ;
        Canvas.TextOut(Rect.Left + 1, Rect.Top + 1, Items[Index]) ;
     end ;
end;

procedure TLinkForm.lbLinksMeasureItem(Control: TWinControl;
  Index: Integer; var Height: Integer);
begin
     if Index = 0 then
        TListBox(Control).Canvas.Font.Style := [fsBold] ;
     Height := TListBox(Control).Canvas.TextHeight( TListBox(Control).Items[Index] ) + 1 ;
end;

procedure TLinkForm.Image1DblClick(Sender: TObject);
begin
     MessageDlg( Image1.Hint, mtInformation, [mbOK], 0) ;
end;

procedure TLinkForm.lblGregLiefURLDblClick(Sender: TObject);
begin
     ShellExecute(0, 'open', PChar( (Sender as TLabel).Caption ), nil, nil, SW_SHOWNORMAL) ;
end;

initialization
begin
     LinksFile := ExtractFilePath(Application.ExeName) + LinksFile ;
end ;

end.
